﻿using System;
using System.Collections.Generic;
using System.Text;

using Thomas_Erdoesi.Game_Analyzer;

namespace Thomas_Erdoesi.Game_Objects
{
    public class GameObjectDistance
    {
        public int dx;
        public int dy;

        public int size;

        public GameObjectDistance() 
            : this(0, 0, 0)
        {
        }

        public GameObjectDistance(int dx, int dy)
            : this(dx, dy, 0)
        {
        }

        public GameObjectDistance(int dx, int dy, int size)
        {
            this.dx = dx;
            this.dy = dy;
            this.size = size;
        }

        public GameObjectDistance(GameObjectLocation Location1, GameObjectLocation Location2)
            : this(Location1, 0, Location2, 0)
        {
        }

        public GameObjectDistance(GameObjectLocation Location1, int Size1, GameObjectLocation Location2, int Size2)
        {
            size = Size1 + Size2;

            dx = Location2.x - Location1.x;
            dy = Location2.y - Location1.y;

            while (dx > GameConstants.MaxDistX) dx -= GameConstants.SizeX;
            while (dx < GameConstants.MinDistX) dx += GameConstants.SizeX;
            while (dy > GameConstants.MaxDistY) dy -= GameConstants.SizeY;
            while (dy < GameConstants.MinDistY) dy += GameConstants.SizeY;
        }

        public double ObjectDistance
        {
            get { return Math.Sqrt(dx * dx + dy * dy) - size; }
        }

        public double CenterDistance
        {
            get { return Math.Sqrt(dx * dx + dy * dy); }
        }

        public static GameObjectDistance MaxDistance
        {
            get { return new GameObjectDistance(GameConstants.SizeX, GameConstants.SizeY); }
        }
    }
}
